/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobContainer {
    private final float width;
    private final float height;
    private final boolean isAquarium;
    @Nullable
    private MobNBTData data;
    @Nullable
    private CapturedMobInstance<?> mobInstance;
    private ICatchableMob mobProperties;
    private boolean needsInitialization = false;

    public MobContainer(float width, float height, boolean isAquarium) {
        this.width = width;
        this.height = height;
        this.isAquarium = isAquarium;
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.data != null) {
            this.data.save(tag, this.isAquarium);
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        MobNBTData d = MobNBTData.load(tag);
        this.setData(d);
    }

    private void setData(@Nullable MobNBTData data) {
        this.data = data;
        this.mobInstance = null;
        this.needsInitialization = true;
    }

    private void initializeEntity(Level level, BlockPos pos) {
        this.needsInitialization = false;
        if (this.data != null && level != null && pos != null) {
            MobNBTData mobNBTData = this.data;
            if (mobNBTData instanceof MobNBTData.Bucket) {
                MobNBTData.Bucket bucketData = (MobNBTData.Bucket)mobNBTData;
                type = BucketHelper.getEntityTypeFromBucket(bucketData.filledBucket.m_41720_());
                this.mobProperties = CapturedMobHandler.getDataCap(type, true);
            } else {
                MobNBTData.Entity entityData;
                Entity entity;
                type = this.data;
                if (type instanceof MobNBTData.Entity && (entity = MobContainer.createStaticMob(entityData = (MobNBTData.Entity)type, level, pos)) != null) {
                    this.mobProperties = CapturedMobHandler.getCatchableMobCapOrDefault(entity);
                    this.mobInstance = this.mobProperties.createCapturedMobInstance(entity, this.width, this.height);
                    this.mobInstance.onContainerWaterlogged(level.m_6425_(pos).m_76152_() != Fluids.f_76191_);
                    this.updateLightLevel(level, pos);
                }
            }
        }
    }

    public void updateLightLevel(Level level, BlockPos pos) {
        int light = 0;
        if (level != null && !level.f_46443_ && this.data != null) {
            BlockState state;
            if (this.mobProperties != null) {
                light = this.mobProperties.getLightLevel(level, pos);
            }
            if ((Integer)(state = level.m_8055_(pos)).m_61143_((Property)ModBlockProperties.LIGHT_LEVEL_0_15) != light) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
    }

    @Nullable
    public static Entity createStaticMob(MobNBTData.Entity data, @NotNull Level world, BlockPos pos) {
        Entity entity = null;
        if (data != null) {
            entity = MobContainer.createEntityFromNBT(data.mobTag, data.uuid, world);
            if (entity == null) {
                return null;
            }
            double px = (double)pos.m_123341_() + entity.m_20185_();
            double py = (double)pos.m_123342_() + entity.m_20186_();
            double pz = (double)pos.m_123343_() + entity.m_20189_();
            entity.m_6034_(px, py, pz);
            entity.f_19790_ = px;
            entity.f_19791_ = py;
            entity.f_19792_ = pz;
            entity.f_19854_ = px;
            entity.f_19855_ = py;
            entity.f_19856_ = pz;
        }
        return entity;
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundTag tag, @Nullable UUID id, Level world) {
        if (tag != null && tag.m_128441_("id")) {
            Entity entity = EntityType.m_20645_((CompoundTag)tag, (Level)world, o -> o);
            if (id != null && entity != null) {
                entity.m_20084_(id);
                if (entity.m_8077_()) {
                    entity.m_6593_(entity.m_7770_());
                }
            }
            return entity;
        }
        return null;
    }

    public boolean interactWithBucket(ItemStack stack, Level world, BlockPos pos, @Nullable Player player, InteractionHand hand) {
        Item item = stack.m_41720_();
        ItemStack returnStack = ItemStack.f_41583_;
        if (this.isEmpty()) {
            if (BucketHelper.isFishBucket(item)) {
                world.m_5594_(null, pos, SoundEvents.f_11779_, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = new ItemStack((ItemLike)Items.f_42446_);
                EntityType<?> type = BucketHelper.getEntityTypeFromBucket(stack.m_41720_());
                ICatchableMob cap = CapturedMobHandler.getDataCap(type, true);
                Optional<Holder<SoftFluid>> f = cap.shouldRenderWithFluid();
                ResourceLocation fluidId = f.map(Utils::getID).orElse(null);
                if (stack.m_41619_()) {
                    Supplementaries.LOGGER.error("Bucket error 3: name none, bucket " + stack + " fluid, " + fluidId);
                }
                MobNBTData.Bucket data = new MobNBTData.Bucket(null, stack.m_41777_(), cap.getFishTextureIndex(), fluidId);
                this.setData(data);
            }
        } else if (item == Items.f_42446_) {
            ItemStack bucket;
            Object temp;
            MobNBTData cap = this.data;
            if (cap instanceof MobNBTData.Bucket) {
                MobNBTData.Bucket bucketData = (MobNBTData.Bucket)cap;
                world.m_5594_(null, pos, SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = bucketData.filledBucket.m_41777_();
                this.setData(null);
            } else if (this.data instanceof MobNBTData.Entity && this.mobInstance != null && (temp = this.mobInstance.getEntityForRenderer()) != null && !(bucket = BucketHelper.getBucketFromEntity(temp)).m_41619_()) {
                world.m_5594_(null, pos, SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = bucket.m_41777_();
                this.setData(null);
            }
        }
        if (!returnStack.m_41619_()) {
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                if (!player.m_7500_()) {
                    Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void tick(Level pLevel, BlockPos pPos) {
        MobNBTData mobNBTData;
        if (this.needsInitialization) {
            this.initializeEntity(pLevel, pPos);
        }
        if (this.mobInstance != null && (mobNBTData = this.data) instanceof MobNBTData.Entity) {
            MobNBTData.Entity entityData = (MobNBTData.Entity)mobNBTData;
            this.mobInstance.containerTick(pLevel, pPos, entityData.scale, entityData.mobTag);
        }
    }

    public InteractionResult onInteract(Level world, BlockPos pos, Player player, InteractionHand hand) {
        MobNBTData mobNBTData;
        if (this.mobInstance != null && (mobNBTData = this.data) instanceof MobNBTData.Entity) {
            MobNBTData.Entity entityData = (MobNBTData.Entity)mobNBTData;
            return this.mobInstance.onPlayerInteract(world, pos, player, hand, entityData.mobTag);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MobNBTData getData() {
        return this.data;
    }

    @Nullable
    public Entity getDisplayedMob() {
        if (this.mobInstance != null) {
            return this.mobInstance.getEntityForRenderer();
        }
        return null;
    }

    public Optional<Holder<SoftFluid>> shouldRenderWithFluid() {
        if (this.data == null || !this.isAquarium || this.mobProperties == null) {
            return Optional.empty();
        }
        return this.mobProperties.shouldRenderWithFluid();
    }

    public static CompoundTag createMobHolderItemTag(Entity mob, float blockW, float blockH, ItemStack bucketStack, boolean isAquarium) {
        MobNBTData data;
        String name = mob.m_7755_().getString();
        ICatchableMob cap = CapturedMobHandler.getCatchableMobCapOrDefault(mob);
        if (isAquarium && !bucketStack.m_41619_() && cap.renderAs2DFish()) {
            Optional<Holder<SoftFluid>> f = cap.shouldRenderWithFluid();
            ResourceLocation fluidId = f.map(Utils::getID).orElse(null);
            if (bucketStack.m_41619_()) {
                Supplementaries.LOGGER.error("Bucket error 2: name " + name + ", bucket " + bucketStack + " fluid, " + fluidId);
            }
            data = new MobNBTData.Bucket(name, bucketStack, cap.getFishTextureIndex(), fluidId);
        } else {
            Pair<Float, Float> dimensions = MobContainer.calculateMobDimensionsForContainer(mob, blockW, blockH, false);
            float scale = ((Float)dimensions.getLeft()).floatValue();
            float yOffset = ((Float)dimensions.getRight()).floatValue();
            CompoundTag mobTag = MobContainer.prepareMobTagForContainer(mob, yOffset);
            if (mobTag == null) {
                return null;
            }
            UUID id = mob.m_20148_();
            data = new MobNBTData.Entity(name, mobTag, scale, id);
        }
        CompoundTag cmp = new CompoundTag();
        ((MobNBTData)data).save(cmp, isAquarium && cap.renderAs2DFish());
        return cmp;
    }

    @Nullable
    private static CompoundTag prepareMobTagForContainer(Entity entity, double yOffset) {
        Mob mob;
        double px = 0.5;
        double py = yOffset + 1.0E-4;
        double pz = 0.5;
        entity.m_6034_(px, py, pz);
        entity.f_19790_ = px;
        entity.f_19791_ = py;
        entity.f_19792_ = pz;
        if (entity.m_20159_()) {
            entity.m_20202_().m_20153_();
        }
        if (entity instanceof Mob && !((mob = (Mob)entity) instanceof Allay) && entity instanceof Bucketable) {
            mob.m_21530_();
        }
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_27497_(true);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.f_20886_ = 0.0f;
            le.f_20885_ = 0.0f;
            le.f_267362_.m_267771_(0.0f);
            le.f_267362_.m_267566_(-le.f_267362_.m_267756_(), 1.0f);
            le.f_267362_.m_267771_(0.0f);
            le.f_20917_ = 0;
            le.f_20916_ = 0;
            le.f_20921_ = 0.0f;
        }
        entity.m_146922_(0.0f);
        entity.f_19859_ = 0.0f;
        entity.f_19860_ = 0.0f;
        entity.m_146926_(0.0f);
        entity.m_20095_();
        entity.f_19802_ = 0;
        if (entity instanceof Bat) {
            Bat bat = (Bat)entity;
            bat.m_27456_(true);
        }
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            fox.m_28626_(true);
        }
        if (entity instanceof AbstractFish) {
            AbstractFish abstractFish = (AbstractFish)entity;
            abstractFish.m_27497_(true);
        }
        CompoundTag mobTag = new CompoundTag();
        entity.m_20223_(mobTag);
        if (mobTag.m_128456_()) {
            Supplementaries.LOGGER.error("failed to capture entity " + entity + "Something went wrong :/");
            return null;
        }
        mobTag.m_128473_("Passengers");
        mobTag.m_128473_("Leash");
        mobTag.m_128473_("UUID");
        if (mobTag.m_128441_("FromBucket")) {
            mobTag.m_128379_("FromBucket", true);
        }
        if (mobTag.m_128441_("FromPot")) {
            mobTag.m_128379_("FromPot", true);
        }
        return mobTag;
    }

    public static Pair<Float, Float> calculateMobDimensionsForContainer(Entity mob, float blockW, float blockH, boolean waterlogged) {
        float yOffset;
        String name;
        LivingEntity livingEntity;
        ICatchableMob cap = CapturedMobHandler.getCatchableMobCapOrDefault(mob);
        float babyScale = 1.0f;
        if (mob instanceof LivingEntity && (livingEntity = (LivingEntity)mob).m_6162_()) {
            babyScale = mob instanceof Villager ? 1.125f : (mob instanceof AgeableMob ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.m_20205_() * babyScale;
        float h = mob.m_20206_() * babyScale;
        boolean isAir = cap.shouldHover(mob, waterlogged);
        float aW = w + cap.getHitBoxWidthIncrement(mob);
        float aH = h + cap.getHitBoxHeightIncrement(mob);
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = blockH - 2.0f * (isAir ? margin : yMargin);
        float maxW = blockW - 2.0f * margin;
        if (aW > maxW || aH > maxH) {
            scale = aW - maxW > aH - maxH ? maxW / aW : maxH / aH;
        }
        if ((name = Utils.getID((EntityType)mob.m_6095_()).toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale = (float)((double)scale * 0.45);
        }
        float f = yOffset = isAir ? blockH / 2.0f - aH * scale / 2.0f : yMargin;
        if (mob instanceof Bat) {
            yOffset *= 1.5f;
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }

    public void clear() {
        this.setData(null);
    }

    public static abstract class MobNBTData {
        protected final String name;
        protected int fishTexture;
        @Nullable
        protected ResourceLocation fluidID;

        private MobNBTData(String name, int fishTexture, @Nullable ResourceLocation fluidID) {
            this.name = name;
            this.fishTexture = fishTexture;
            this.fluidID = fluidID;
        }

        public boolean is2DFish() {
            return this.fishTexture != 0;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        @Nullable
        public ResourceLocation getFluidID() {
            return this.fluidID;
        }

        protected abstract void save(CompoundTag var1, boolean var2);

        @Nullable
        protected static MobNBTData load(CompoundTag tag) {
            if (tag.m_128441_("BucketHolder")) {
                return Bucket.of(tag.m_128469_("BucketHolder"));
            }
            if (tag.m_128441_("MobHolder")) {
                return Entity.of(tag.m_128469_("MobHolder"));
            }
            return null;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        protected static class Bucket
        extends MobNBTData {
            private final ItemStack filledBucket;

            protected Bucket(@Nullable String name, ItemStack filledBucket, int fishTexture, @Nullable ResourceLocation fluidId) {
                super(Bucket.getDefaultName(name, filledBucket), fishTexture, fluidId);
                this.filledBucket = filledBucket;
            }

            private static String getDefaultName(@Nullable String name, @NotNull ItemStack filledBucket) {
                if (name == null) {
                    EntityType<?> type = BucketHelper.getEntityTypeFromBucket(filledBucket.m_41720_());
                    name = type == null ? "Mob" : type.m_20675_();
                }
                return name;
            }

            @Override
            protected void save(CompoundTag tag, boolean rendersAsFish) {
                CompoundTag cmp = new CompoundTag();
                cmp.m_128359_("Name", this.name);
                cmp.m_128365_("Bucket", (Tag)this.filledBucket.m_41739_(new CompoundTag()));
                if (rendersAsFish) {
                    cmp.m_128405_("FishTexture", this.fishTexture);
                    if (this.fluidID != null) {
                        cmp.m_128359_("Fluid", this.fluidID.toString());
                    }
                }
                tag.m_128365_("BucketHolder", (Tag)cmp);
            }

            private static Bucket of(CompoundTag cmp) {
                String name = cmp.m_128461_("Name");
                int fish = cmp.m_128451_("FishTexture");
                ItemStack bucket = ItemStack.m_41712_((CompoundTag)cmp.m_128469_("Bucket"));
                ResourceLocation fluid = null;
                if (cmp.m_128441_("Fluid")) {
                    fluid = new ResourceLocation(cmp.m_128461_("Fluid"));
                }
                if (bucket.m_41619_()) {
                    Supplementaries.LOGGER.error("Bucket error 1: name " + name + ", bucket " + bucket + " fluid, " + fluid);
                }
                return new Bucket(name, bucket, fish, fluid);
            }
        }

        public static class Entity
        extends MobNBTData {
            public final CompoundTag mobTag;
            private final float scale;
            @Nullable
            private final UUID uuid;

            protected Entity(String name, CompoundTag tag, float scale, UUID uuid) {
                this(name, 0, null, tag, scale, uuid);
            }

            protected Entity(String name, int fishTexture, @Nullable ResourceLocation fishFluid, CompoundTag tag, float scale, UUID uuid) {
                super(name, fishTexture, fishFluid);
                this.mobTag = tag;
                this.scale = scale;
                this.uuid = uuid;
            }

            private static Entity of(CompoundTag cmp) {
                String name = cmp.m_128461_("Name");
                int fish = cmp.m_128451_("FishTexture");
                ResourceLocation fluid = null;
                if (cmp.m_128441_("Fluid")) {
                    fluid = new ResourceLocation(cmp.m_128461_("Fluid"));
                }
                CompoundTag entityData = cmp.m_128469_("EntityData");
                float scale = cmp.m_128457_("Scale");
                UUID uuid = cmp.m_128441_("UUID") ? cmp.m_128342_("UUID") : null;
                return new Entity(name, fish, fluid, entityData, scale, uuid);
            }

            public float getScale() {
                return this.scale;
            }

            @Override
            protected void save(CompoundTag tag, boolean isAquarium) {
                CompoundTag cmp = new CompoundTag();
                cmp.m_128359_("Name", this.name);
                if (isAquarium) {
                    cmp.m_128405_("FishTexture", this.fishTexture);
                    if (this.fluidID != null) {
                        cmp.m_128359_("Fluid", this.fluidID.toString());
                    }
                }
                cmp.m_128365_("EntityData", (Tag)this.mobTag);
                cmp.m_128350_("Scale", this.scale);
                if (this.uuid != null) {
                    cmp.m_128362_("UUID", this.uuid);
                }
                tag.m_128365_("MobHolder", (Tag)cmp);
            }
        }
    }
}

