/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.globe;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeTextureGenerator;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncGlobeDataPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class GlobeData
extends SavedData {
    private static final int TEXTURE_H = 16;
    private static final int TEXTURE_W = 32;
    public static final String DATA_NAME = "globe_data";
    public final byte[][] globePixels;
    public final long seed;
    private static GlobeData CLIENT_SIDE_INSTANCE = null;

    public GlobeData(long seed) {
        this.seed = seed;
        this.globePixels = GlobeTextureGenerator.generate(this.seed);
    }

    public GlobeData(CompoundTag tag) {
        this.globePixels = new byte[32][16];
        for (int i = 0; i < 32; ++i) {
            this.globePixels[i] = tag.m_128463_("colors_" + i);
        }
        this.seed = tag.m_128454_("seed");
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        for (int i = 0; i < this.globePixels.length; ++i) {
            nbt.m_128382_("colors_" + i, this.globePixels[i]);
        }
        nbt.m_128356_("seed", this.seed);
        return nbt;
    }

    public void sendToClient(Level world) {
        this.m_77762_();
        if (!world.f_46443_) {
            NetworkHandler.CHANNEL.sendToAllClientPlayers((Message)new ClientBoundSyncGlobeDataPacket(this));
        }
    }

    @Nullable
    public static GlobeData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            return (GlobeData)world.m_7654_().m_129783_().m_8895_().m_164861_(GlobeData::new, () -> new GlobeData(server.m_7328_()), DATA_NAME);
        }
        return CLIENT_SIDE_INSTANCE;
    }

    public static void set(ServerLevel level, GlobeData pData) {
        level.m_7654_().m_129783_().m_8895_().m_164855_(DATA_NAME, (SavedData)pData);
    }

    public static void setClientData(GlobeData data) {
        CLIENT_SIDE_INSTANCE = data;
        GlobeManager.refreshTextures();
    }

    public static void sendDataToClient(ServerPlayer player) {
        GlobeData data = GlobeData.get(player.m_9236_());
        if (data != null) {
            NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncGlobeDataPacket(data));
        }
    }
}

