/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.SpriteCoordinateUnExpander;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.EnchantRedesignCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BookPileBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final BooksList booksVisuals = new BooksList();
    public static final ModelDataKey<BooksList> BOOKS_KEY = ModBlockProperties.BOOKS_KEY;
    private static final RandomSource rand = RandomSource.m_216327_();
    public static final List<String> DEFAULT_COLORS = List.of("brown", "orange", "yellow", "red", "dark_green", "lime", "teal", "blue", "purple");

    public BookPileBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(BlockPos pos, BlockState state, boolean horizontal) {
        super(ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(BOOKS_KEY, (Object)this.booksVisuals).build();
    }

    private void displayRandomColoredBooks(int i) {
        for (int j = 0; j < i; ++j) {
            int r = rand.m_188503_(10);
            Item it = r < 2 ? Items.f_42690_ : (r < 3 ? Items.f_42614_ : Items.f_42517_);
            ArrayList<BookType> col = PlaceableBookManager.getByItem(it.m_7968_());
            this.booksVisuals.add(new VisualBook(it.m_7968_(), this.f_58858_, j, col, null));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128350_("EnchantPower", this.enchantPower);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.enchantPower = compound.m_128457_("EnchantPower");
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelReload();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateTileOnInventoryChanged() {
        int b = (int)this.m_7086_().stream().filter(i -> !i.m_41619_()).count();
        if (b != (Integer)this.m_58900_().m_61143_((Property)BookPileBlock.BOOKS)) {
            if (b == 0) {
                if (this.f_59605_ != null) return;
                this.f_58857_.m_7471_(this.f_58858_, false);
            } else {
                this.consolidateBookPile();
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(b)), 2);
            }
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            Item item = this.m_8020_(i2).m_41720_();
            if (BookPileBlock.isNormalBook(item)) {
                this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0);
                continue;
            }
            if (BookPileBlock.isQuarkTome(item)) {
                this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.BOOK_POWER.get() / 4.0 * 2.0);
                continue;
            }
            if (!BookPileBlock.isEnchantedBook(item)) continue;
            this.enchantPower = (float)((double)this.enchantPower + CommonConfigs.Tweaks.ENCHANTED_BOOK_POWER.get() / 4.0);
        }
    }

    private void consolidateBookPile() {
        boolean prevEmpty = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack it = this.m_8020_(i);
            if (it.m_41619_()) {
                prevEmpty = true;
                continue;
            }
            if (!prevEmpty) continue;
            this.m_7086_().set(i - 1, (Object)it);
            this.m_7086_().set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void updateClientVisualsOnLoad() {
        ItemStack stack;
        this.booksVisuals.clear();
        ArrayList<BookType> colors = new ArrayList<BookType>();
        for (String v : ClientConfigs.Tweaks.BOOK_COLORS.get()) {
            BookType byName = PlaceableBookManager.getByName(v);
            if (colors.contains(byName)) continue;
            colors.add(byName);
        }
        for (int index = 0; index < 4 && !(stack = this.m_8020_(index)).m_41619_(); ++index) {
            BookType last = index == 0 ? null : this.booksVisuals.get((int)(index - 1)).type;
            this.booksVisuals.add(index, new VisualBook(stack, this.f_58858_, index, colors, last));
        }
        if (this.booksVisuals.isEmpty()) {
            this.displayRandomColoredBooks((Integer)this.m_58900_().m_61143_((Property)BookPileBlock.BOOKS));
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.book_pile");
    }

    public record BooksList(List<VisualBook> books) {
        public BooksList() {
            this(new ArrayList<VisualBook>());
        }

        public void add(VisualBook visualBook) {
            this.books.add(visualBook);
        }

        public void add(int i, VisualBook visualBook) {
            this.books.add(i, visualBook);
        }

        public void clear() {
            this.books.clear();
        }

        public boolean isEmpty() {
            return this.books.isEmpty();
        }

        public VisualBook get(int i) {
            return this.books.get(i);
        }

        public int size() {
            return this.books.size();
        }
    }

    public static class VisualBook {
        private final float yAngle;
        private final BookType type;
        private final ItemStack stack;

        public VisualBook(ItemStack bookStack, BlockPos pos, int index, List<BookType> colors, @Nullable BookType lastColor) {
            this.stack = bookStack;
            Random rand = new Random(pos.m_121878_());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            Item item = bookStack.m_41720_();
            this.yAngle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item instanceof BookItem) {
                if (lastColor == null) {
                    this.type = colors.get(rand.nextInt(colors.size()));
                } else {
                    List<BookType> c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).toList();
                    this.type = c.get(rand.nextInt(c.size()));
                }
                colors.remove(this.type);
            } else {
                ArrayList<BookType> possibleTypes = PlaceableBookManager.getByItem(bookStack);
                this.type = possibleTypes.get(rand.nextInt(possibleTypes.size()));
            }
        }

        public VertexConsumer getBuilder(MultiBufferSource buffer) {
            if (this.type.hasGlint() && ClientConfigs.Tweaks.BOOK_GLINT.get().booleanValue()) {
                VertexConsumer foilBuilder = null;
                if (CompatHandler.ENCHANTEDBOOKREDESIGN) {
                    foilBuilder = EnchantRedesignCompat.getBookColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = new SpriteCoordinateUnExpander(buffer.m_6299_(RenderType.m_110496_()), ModMaterials.BOOK_GLINT_MATERIAL.m_119204_());
                }
                return foilBuilder;
            }
            return null;
        }

        public float getAngle() {
            return this.yAngle;
        }

        public BookType getType() {
            return this.type;
        }
    }
}

