/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.mehvahdjukaar.supplementaries.common.block.ILavaAndWaterLoggable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SafeBlock
extends Block
implements ILavaAndWaterLoggable,
EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LAVALOGGED = ModBlockProperties.LAVALOGGED;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;

    public SafeBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)LAVALOGGED) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LAVALOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OPEN, FACING, WATERLOGGED, LAVALOGGED});
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = serverLevel.m_7702_(pos);
        if (blockEntity instanceof SafeBlockTile) {
            SafeBlockTile tile = (SafeBlockTile)blockEntity;
            tile.recheckOpen();
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)LAVALOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76195_, Fluids.f_76195_.m_6718_((LevelReader)level));
        } else if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        Fluid fluid = fluidState.m_76152_();
        boolean full = fluidState.m_76186_() == 8;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(full && fluid == Fluids.f_76193_))).m_61124_((Property)LAVALOGGED, (Comparable)Boolean.valueOf(full && fluid == Fluids.f_76195_));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SafeBlockTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        SafeBlockTile tile;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockTile && (tile = (SafeBlockTile)blockEntity).handleAction(player, handIn)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, level, tooltip, flagIn);
        CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
        if (compoundTag != null) {
            if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
                UUID id;
                if (compoundTag.m_128441_("Owner") && !(id = compoundTag.m_128342_("Owner")).equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                    String name = compoundTag.m_128461_("OwnerName");
                    tooltip.add((Component)Component.m_237110_((String)"message.supplementaries.safe.owner", (Object[])new Object[]{name}).m_130940_(ChatFormatting.GRAY));
                    return;
                }
                if (compoundTag.m_128425_("LootTable", 8)) {
                    tooltip.add((Component)Component.m_237113_((String)"???????").m_130940_(ChatFormatting.GRAY));
                }
                if (compoundTag.m_128425_("Items", 9)) {
                    NonNullList itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                    ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)itemStacks);
                    int i = 0;
                    int j = 0;
                    for (ItemStack itemstack : itemStacks) {
                        if (itemstack.m_41619_()) continue;
                        ++j;
                        if (i > 4) continue;
                        ++i;
                        MutableComponent component = itemstack.m_41786_().m_6881_();
                        component.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                        tooltip.add((Component)component.m_130940_(ChatFormatting.GRAY));
                    }
                    if (j - i > 0) {
                        tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                    }
                }
                return;
            }
            if (compoundTag.m_128441_("Password")) {
                tooltip.add((Component)Component.m_237115_((String)"message.supplementaries.safe.bound").m_130940_(ChatFormatting.GRAY));
                return;
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"message.supplementaries.safe.unbound").m_130940_(ChatFormatting.GRAY));
    }

    public ItemStack getSafeItem(SafeBlockTile te) {
        CompoundTag compoundTag = te.m_187482_();
        ItemStack itemstack = new ItemStack((ItemLike)this);
        if (!compoundTag.m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        if (te.m_8077_()) {
            itemstack.m_41714_(te.m_7770_());
        }
        return itemstack;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockTile) {
            SafeBlockTile tile = (SafeBlockTile)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && !tile.m_7983_()) {
                ItemStack itemstack = this.getSafeItem(tile);
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            } else {
                tile.m_59640_(player);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof SafeBlockTile) {
            SafeBlockTile tile = (SafeBlockTile)object;
            ItemStack itemstack = this.getSafeItem(tile);
            return Collections.singletonList(itemstack);
        }
        return super.m_49635_(state, builder);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockTile) {
            SafeBlockTile tile = (SafeBlockTile)blockEntity;
            return this.getSafeItem(tile);
        }
        return itemstack;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockTile) {
            SafeBlockTile tile = (SafeBlockTile)blockEntity;
            if (stack.m_41788_()) {
                tile.m_58638_(stack.m_41786_());
            }
            if (placer instanceof Player && tile.getOwner() == null) {
                tile.setOwner(placer.m_20148_());
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            level.m_46717_(pos, state.m_60734_());
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)worldIn.m_7702_(pos));
    }

    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        MenuProvider m;
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof MenuProvider ? (m = (MenuProvider)blockEntity) : null;
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)LAVALOGGED)).booleanValue()) {
            return Fluids.f_76195_.m_76068_(false);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }
}

